<?php 

/**
 * Klasa odpowiedzialna za obsluge obrazkow CMS
 * @author Bartosz Strzala - azureusnet.pl
 */

require_once'./php/klasy/drzewko.php';


class galeria2 extends drzewko
{
	const p = 99;
	
	private $dir = null;
	private $width = null;
	private $height = null;
	
	
	public function __construct($dir, $height = 60, $width = 60) {
		$this->width = $width;
		$this->height = $height;
	}
	
	/**
	 * Funkcja generujaca porstokatne miniaturki
	 * @param $file
	 * @param $flaga
	 * @return void
	 */
	
	public function setThumb(array $file, $flaga) {
		include_once 'Asido/class.asido.php';
		
		asido::driver('gd');

		$thumb = asido::image($file['path'].$file['name'],$file['path'].'/min/200'.$file['name']);
		
		asido::height($thumb,$this->height);
		
		$thumb->save(ASIDO_OVERWRITE_ENABLED);
	}
	
	/**
	 * Funkcja generujaca kwadratowe miniaturki
	 * @todo przerobic parametry na takie jakie sa w poprzedniej funkcji
	 * @param $zdjecie
	 * @param $katalog
	 * @param $tmp_pliku
	 * @param $x
	 * @param $y
	 * @return unknown_type
	 */
	
	function cropImage($source, $dest,$nw,$nh) {
		$size = getimagesize($source);
		$w = $size[0];
		$h = $size[1];
		switch(mime_content_type($source)) {
			case 'image/gif':
				$simg = imagecreatefromgif($source);
				break;
			case 'image/jpg': case 'image/jpeg':
				$simg = imagecreatefromjpeg($source);
				break;
			case 'image/png':
				$simg = imagecreatefrompng($source);
				break;
		}
		$dimg = imagecreatetruecolor($nw, $nh);
//		$white = imagecolorallocate($dimg, 245, 245, 245);
                $white = imagecolorallocatealpha($dimg, 255, 255, 255, 0);
		imagefill($dimg, 0, 0, $white);
                imagefilledrectangle($dimg, 0, 0, $nw - 1, $nh - 1, $white);
		$wm = $w/$nw;
		$hm = $h/$nh;
		$h_height = $nh/2;
		$w_height = $nw/2;
		if($w> $h) {
			$adjusted_width = $w / $hm;
			$half_width = $adjusted_width / 2;
			$int_width = $half_width - $w_height;
			imagecopyresampled($dimg,$simg,-$int_width,0,0,0,$adjusted_width,$nh,$w,$h);
		} elseif(($w <$h) || ($w == $h)) {
			$adjusted_height = $h / $wm;
			$half_height = $adjusted_height / 2;
			$int_height = $half_height - $h_height;
			imagecopyresampled($dimg,$simg,0,-10,0,0,$nw,$adjusted_height,$w,$h);
		} else {
			imagecopyresampled($dimg,$simg,0,0,0,0,$nw,$nh,$w,$h);
		}

		switch(mime_content_type($source)) {
			case 'image/gif':
				$result 	=	imagegif($dimg,$dest);
				break;
			case 'image/jpg': case 'image/jpeg':
				$result 	=	imagejpeg($dimg,$dest,100);
				break;
			case 'image/png':
				$result 	=	imagepng($dimg,$dest,100);
				break;
		}
		
		return $result;
	}
	
	public function stworz_miniaturki($zdjecie,$katalog,$tmp_pliku,$x,$y) {
		
		$miniaturka = imagecreatefromjpeg($katalog.$zdjecie);
		list($ow, $oh) = getimagesize($tmp_pliku);
		$big = imagecreatefromjpeg($tmp_pliku);
		$thumb = imagecreatetruecolor($x,$y);
		$white = imagecolorallocate($thumb, 255, 255, 255);
		imagefilledrectangle($thumb, 0, 0, $x, $y, $white);
		
		$xskala=$ow/$x;
		$yskala=$oh/$y;
		
		if ($yskala<1 && $xskala<1)
		{
			$dis_w = round(($x-$ow)/2);
			$dis_h = round(($y-$oh)/2);
			imagecopyresampled($thumb, $big, $dis_w, $dis_h, 0, 0, $ow, $oh, $ow, $oh);
		}
		else
		{
			$ramka_w=$x;
			$ramka_h=$y;	
			if ($yskala>$xskala)
			{
				$x = round($ow * (1/$yskala));
				$y = round($oh * (1/$yskala));
			}
			else 
			{
				$x = round($ow * (1/$xskala));
				$y = round($oh * (1/$xskala));
			}	
			
			$dis_w = round(($ramka_w-$x)/2);
			$dis_h = round(($ramka_h-$y)/2);
			imagecopyresampled($thumb, $big, $dis_w, $dis_h, 0, 0, $x, $y, $ow, $oh);
		}
		
		imagejpeg($thumb, $katalog.'min/'.$zdjecie, 100);
	}
	
	public function form() {
		if(isset($_GET['id_s']))$id_s = (int)$_GET['id_s'];
		if(isset($_GET['nr']))$id = (int)$_GET['nr'];
			
		$new = new generatorFormularzy('Galeria','?p=99&a=1&id='.$_GET['id'].'&frame', 'POST', 'enctype="multipart/form-data"');
		$new->poczatekForm();
		$new->input('Zdjęcie', 'file', '', '', '', true);
		$new->text('<br />');
                $new->inupt('Tytuł PL', 'text',$tab['tytul_pl'],'','textlong');
                $new->inupt('Tytuł EN', 'text',$tab['tytul_en'],'','textlong');
                $new->inupt('Tytuł DE', 'text',$tab['tytul_de'],'','textlong');
                $new->text('<br />');
                $new->textarea('Opis PL', 30, 30,'',stripslashes($tab['opis_pl']));
                $new->text('<br />');
                $new->textarea('Opis EN', 30, 30,'',stripslashes($tab['opis_en']));
                $new->text('<br />');
                $new->textarea('Opis DE', 30, 30,'',stripslashes($tab['opis_de']));
                $new->text('<br />');
//                $new->select('kategoria', $this->displayTreeSelect(), $tab['kategoria']);
		$new->input('submit', 'submit', 'Dodaj plik', '', 'searchbutton', false);
		$new->input('r', 'hidden', time(), '', '', false);
		$new->input('co', 'hidden', $_GET['co'], '', '', false);
		$new->input('id', 'hidden', $_GET['id'], '', '', false);
		$new->koniecForm();		
	}
	
	public function add() {
		$smarty = Zend_Registry::get('smarty');

		$tab = explode('.',$_FILES['zdjecie']['name']);

                $dane['kategoria'] = $_GET['id'];
                $dane['opis_pl'] = $_POST['opis_pl'];
                $dane['opis_en'] = $_POST['opis_en'];
                $dane['opis_de'] = $_POST['opis_de'];

                $dane['tytul_pl'] = $_POST['tytul_pl'];
                $dane['tytul_en'] = $_POST['tytul_en'];
                $dane['tytul_de'] = $_POST['tytul_de'];
		
		if($tab[1]!='jpg' && $tab[1]!='jpeg' && $tab[1]!='JPG' && $tab[1]!='JPEG' && $tab[1]!='png' && $tab[1]!='PNG' && $tab[1]!='gif' && $tab[1]!='GIF')
		{
			$error = array();
			$error['typ'] = 'error';
			$error['tekst'] = '<img src="./images/nok.png" alt="" style="vertical-align:middle;width:24px;padding-right:5px;" />Błąd. Niewłaściwy format pliku. Wymagane pliki *.<strong>jpg, png, gif</strong>. <a href="?p='.(int)$_GET['p'].'&a=6">Spróbuj ponownie</a>';
			$smarty->assign('komunikat',$error);
		}
			
		else
		{
			if(isset($_SESSION['form']) && $_SESSION['form']==$_POST['r'])throw new Exception('Nie odświeżaj strony!');
			$_SESSION['form'] = $_POST['r'];
				
			$id = (int)$_GET['id'];
				
			global $_FILES;

			$NazwaPliku = $_FILES['zdjecie']['name'];
			$RozmiarPliku = $_FILES['zdjecie']['size'];
			$TymczasowaNazwaPliku = $_FILES['zdjecie']['tmp_name'];
			$Blad = $_FILES['zdjecie']['error'];
				
			$nameOfFile = $NazwaPliku;
			$NazwaPliku = md5(date('Ydmhis').$id).'.'.end($tab);
			$katalog = '../galeria/';
			$katalog_min = $katalog.'min/';
                        $katalog_thumb = $katalog.'thumb/';

			if(!is_dir($katalog_min))
			{
				mkdir($katalog_min);
				chmod($katalog_min,0777);
			}
				
			if(is_uploaded_file($TymczasowaNazwaPliku))
			{
				if(move_uploaded_file($TymczasowaNazwaPliku, $katalog.$NazwaPliku))
				{
					chmod($katalog.$NazwaPliku,0755);

					$this->cropImage($katalog.$NazwaPliku, $katalog_min.$NazwaPliku,275,206);
                                        $this->cropImage($katalog.$NazwaPliku, $katalog_thumb.$NazwaPliku,76,55);
					
					$dane['kategoria'] = $id;
					$dane['nazwa'] = $NazwaPliku;
					$dane['nazwa_prawdziwa'] = $nameOfFile;
					
					$db = Zend_Registry::get('db');
						
					$db->insert(Index::dbPrefiks.'obrazki2',$dane);
					
					$smarty->assign('komunikat', array('typ'=>'info', 'tekst'=> '<img src="./images/ok.png" alt="" style="vertical-align:middle;width:24px;padding-right:5px;" />Plik <b>'.$dane['nazwa_prawdziwa'].'</b> został poprawnie dodany.'));
					$result = true;
				}

				else
				{
					$smarty->assign('komunikat', array('typ'=>'error', 'tekst'=> '<img src="./images/nok.png" alt="" style="vertical-align:middle;width:24px;padding-right:5px;" />Wystąpił błąd1: '.$Blad));
				}
			}

			else
			{
				$smarty->assign('komunikat', array('typ'=>'error', 'tekst'=> '<img src="./images/nok.png" alt="" style="vertical-align:middle;width:24px;padding-right:5px;" />Wystąpił błąd2: '.$katalog));
			}

			$this->menu();
			return $result;
		}		
	}
	
	public function lista()
	{
		try
		{
			$db = Zend_Registry::get('db');
			$smarty = Zend_Registry::get('smarty');

			$sql="SELECT * FROM ".Index::dbPrefiks."obrazki2 WHERE kategoria='".$_GET['id']."'";
			$result = $db->fetchAll($sql);
			
			if(count($result) <= 50) {
				$smarty->assign('submenu', array(0 => array('link' => '?p='.self::p.'&a=2&id='.$_GET['id'].'&frame', 'tekst' => '<img src="./images/add-gallery.png" alt="" style="vertical-align:middle;width:32px;padding-right:5px;" />Dodaj nowee zdjęcie')));
			}
			
			$smarty->assign('lista', $result);
			
		}
		catch (Zend_Db_Adapter_Exception $e)
		{
			przechwyc_blad($e);
		}
			
		catch (Zend_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
	}
	
	public function delete()
	{
		$db = Zend_Registry::get('db');
		$smarty = Zend_Registry::get('smarty');	

		$db->delete(Index::dbPrefiks.'obrazki2', 'id='.$_GET['id']);
		
		@ulink('..'.$result[0]['path'].'/'.$result[0]['nazwa_prawdziwa']);
		
		$smarty->assign('komunikat', array('typ'=>'info', 'tekst'=> '<img src="./images/ok.png" alt="" style="vertical-align:middle;width:24px;padding-right:5px;" />Plik został poprawnie usunięty.'));
		$this->lista();
                $this->menu();
	}
	
	public function menu()
	{
		$this->lista();
	}
}
?>